---
title: Data Processing using AWK
summary: Process text data using the awk command
---

AWK is an extremely sophisticated pattern scanning and processing language thats implementation facilitates the manipulation of structured data and the generation of formatted reports. It's particularly useful when working with CSV files, log files, and any text data organized in columns.

## Basic Structure

The basic structure is:

```bash
awk 'pattern { action }' filename
```

Let's analyze a simple web server log:

```
# access.log
192.168.1.100 GET /index.html 200
10.0.0.1 POST /api/users 201
192.168.1.100 GET /images/logo.png 404
```

Count successful requests:
```bash
awk '$4 == "200" { count++ } END { print count }' access.log
```

## Printing specific fields

You can print specific fields like this:

```bash
awk '{print $1, $3}' data.txt
```

For example, with a CSV of sales:

```
# sales.csv
Date,Product,Quantity,Price
2024-01-01,Widget,5,10.99
2024-01-02,Gadget,3,25.50
```

Print date and price:
```bash
awk -F',' '{print $1, $4}' sales.csv
```

## doing Calculations

We can do calculations on fields. Let's calculate total sales:

```bash
awk -F',' 'NR>1 {sum += $3 * $4} END {print "Total: $" sum}' sales.csv
```

Some more xamples:

```bash
# Average request time from logs
awk '{sum += $5} END {print "Average: " sum/NR}' timing.log

# Count occurrences by category
awk '{count[$3]++} END {for (cat in count) print cat, count[cat]}' events.log
```

## Wrapping up

AWK is an insanely versatile tool for data processing. Keep experimenting with it! The more you practice, the better you'll understand its capabilities.
