---
title: Finding Files in Linux
summary: Navigate your filesystem using the find command
---

The find command helps you locate files and directories. We'll explore it's most useful options for managing your filesystem effectively.

## Basic Usage

Find all files in current directory:

```bash
find .
```

This will list everything recursively, which can be overwhelming. Let's make it more usefull:

```bash
# List only files (not directories)
find . -type f

# List only directories
find . -type d
```

## Finding by name

To find specific files:

```bash
find . -name "*.txt"
```

Real-world examples:

```bash
# Find all Python files modified today
find . -name "*.py" -mtime -1

# Find configuration backups
find /etc -name "*.bak"

# Case-insensitive search for images
find ~/Pictures -iname "*.jpg"
```

## Advanced Search Options

Simply combine multiple criteria:

```bash
# Find large files modified in last week
find . -type f -size +1M -mtime -7

# Find empty files
find . -type f -empty

# Find files with specific permissions
find . -type f -perm 644
```

## Executing Commands

You can run commands on found files:

```bash
# Delete all .tmp files
find . -name "*.tmp" -exec rm {} \;

# Compress old log files
find /var/log -name "*.log" -mtime +30 -exec gzip {} \;
```

## Conclusion

Find is a powerful tool for locating files. Practice these examples to get better at it, and always be carefull when using `-exec` with destructive commands.
