---
title: Search text using grep
description: Find patterns in your files using grep
---

Grep lets you search through files for specific patterns. Its name comes from the ed command g/re/p (globally search for a regular expression and print matching lines). We'll explore common use cases for developers and system administrators.

## Simple Searching

Search for a word:

```bash
grep "error" logfile.txt
```

When working with your codebase, you might want to find all TODO comments that need to be addressed before a release. This is particularly useful for tech debt tracking in monorepos.

```bash
grep "TODO" *.py
```

## Using Regular Expressions

Learn how to use regex patterns:

```bash
grep "^Error.*failed$" errors.log
```

When working with customer data stores, you might need to extract all email addresses from contact information exports.

```bash
grep -E "[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,}" contacts.txt
```

## Nginx Log Analysis

nginx web servers generate detailed access and error logs that can be mined for insights. Find all requests that resulted in 5xx server-side errors:

```bash
grep -E '"(GET|POST) .* HTTP/[0-9.]+" 5[0-9]{2}' /var/log/nginx/access.log
```

## Recursive Search

Search all files in directory:

```bash
grep -r "TODO" .
```

For diagnosing application errors, it's helpful to see the context around an exception in your stack traces and log streams.

```bash
grep -C 3 "Exception" app.log
```

## Excluding Files

Modern software projects include many dependencies and generated artifacts that you'll want to exclude from searches. Monorepos especially have this issue.

When searching in JavaScript projects, you typically want to skip the `node_modules` directory:

```bash
grep -r --exclude-dir={node_modules,vendor} "TODO" .
```

For repos with multiple programming languages, you can focus on specific file sets:

```bash
grep --include="*.py" -r "def main" .
```

## Conclusion

Congratulations! You learned a new tool.

Grep is an essential tool for finding text patterns. Its flexibility makes it invaluable for debugging, code review, and system administration tasks across your microservice architecture.
